#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Apr 25 12:11:06 2020

@author: yann
"""

import numpy as np
import matplotlib.pyplot as plt

w=10
lt=np.linspace(0,2,1000)
def s1(t):
    return np.sin(w*t)


#%%
plt.plot(lt,s1(lt),'b-',label='S1')

plt.xlabel("temps")
plt.ylabel("signal")
plt.title("sinusoïde seule")
plt.legend()
plt.show()

#%%
phi=2
def s2(t):
    return np.sin(w*t+phi)
plt.plot(lt,s1(lt),'b-',label='S1')
plt.plot(lt,s2(lt),'g-',label='S2')
plt.xlabel("temps")
plt.ylabel("signal")
plt.title("sinusoïdes déphasées")
plt.legend()

plt.show()
#%%
phi=2
def somme(t):
    return s1(t)+s2(t)

plt.plot(lt,s1(lt),'b-',label='S1')
plt.plot(lt,s2(lt),'g-',label='S2')
plt.plot(lt,somme(lt),'r-',label='S1+S2')
plt.xlabel("temps")
plt.ylabel("signal")
plt.title("sinusoïdes déphasées")
plt.legend()
plt.show()
#%%
phi=np.pi/2

plt.plot(lt,somme(lt),'r-',label='S1+S2')
plt.xlabel("temps")
plt.ylabel("signal")
plt.title("sinusoïdes déphasées")
plt.legend()
plt.show()
#%%
lphi=np.linspace(0,np.pi,7)
for phi in lphi:
    plt.plot(lt,somme(lt),label='phi='+str(round(phi,1)))
plt.xlabel("temps")
plt.ylabel("signal")
plt.title("sinusoïdes déphasées")
plt.legend()
plt.show()
